if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface SelfDiscipline_Params {
    currentTime?: string;
    modeEnabled?: boolean;
    studySeconds?: number;
    isStudying?: boolean;
    todayTotalSeconds?: number;
    showAnalysis?: boolean;
    historyRecords?: HistoryRecord[];
    studyTimerId?: number;
    timeUpdateTimerId?: number;
    preference?: preferences.Preferences | null;
    hasInitialized?: boolean;
    globalDarkMode?: boolean;
    listenerId?: string;
}
import router from "@ohos:router";
import preferences from "@ohos:data.preferences";
import ThemeManager from "@bundle:com.example.myapplication/entry/ets/common/ThemeManager";
// 定义历史记录接口
interface HistoryRecord {
    date: string;
    seconds: number;
    formattedTime: string;
}
class SelfDiscipline extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__currentTime = new ObservedPropertySimplePU('', this, "currentTime");
        this.__modeEnabled = new ObservedPropertySimplePU(false, this, "modeEnabled");
        this.__studySeconds = new ObservedPropertySimplePU(0, this, "studySeconds");
        this.__isStudying = new ObservedPropertySimplePU(false, this, "isStudying");
        this.__todayTotalSeconds = new ObservedPropertySimplePU(0, this, "todayTotalSeconds");
        this.__showAnalysis = new ObservedPropertySimplePU(false, this, "showAnalysis");
        this.__historyRecords = new ObservedPropertyObjectPU([], this, "historyRecords");
        this.studyTimerId = 0;
        this.timeUpdateTimerId = 0;
        this.preference = null;
        this.hasInitialized = false;
        this.__globalDarkMode = new ObservedPropertySimplePU(false, this, "globalDarkMode");
        this.listenerId = '';
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: SelfDiscipline_Params) {
        if (params.currentTime !== undefined) {
            this.currentTime = params.currentTime;
        }
        if (params.modeEnabled !== undefined) {
            this.modeEnabled = params.modeEnabled;
        }
        if (params.studySeconds !== undefined) {
            this.studySeconds = params.studySeconds;
        }
        if (params.isStudying !== undefined) {
            this.isStudying = params.isStudying;
        }
        if (params.todayTotalSeconds !== undefined) {
            this.todayTotalSeconds = params.todayTotalSeconds;
        }
        if (params.showAnalysis !== undefined) {
            this.showAnalysis = params.showAnalysis;
        }
        if (params.historyRecords !== undefined) {
            this.historyRecords = params.historyRecords;
        }
        if (params.studyTimerId !== undefined) {
            this.studyTimerId = params.studyTimerId;
        }
        if (params.timeUpdateTimerId !== undefined) {
            this.timeUpdateTimerId = params.timeUpdateTimerId;
        }
        if (params.preference !== undefined) {
            this.preference = params.preference;
        }
        if (params.hasInitialized !== undefined) {
            this.hasInitialized = params.hasInitialized;
        }
        if (params.globalDarkMode !== undefined) {
            this.globalDarkMode = params.globalDarkMode;
        }
        if (params.listenerId !== undefined) {
            this.listenerId = params.listenerId;
        }
    }
    updateStateVars(params: SelfDiscipline_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__currentTime.purgeDependencyOnElmtId(rmElmtId);
        this.__modeEnabled.purgeDependencyOnElmtId(rmElmtId);
        this.__studySeconds.purgeDependencyOnElmtId(rmElmtId);
        this.__isStudying.purgeDependencyOnElmtId(rmElmtId);
        this.__todayTotalSeconds.purgeDependencyOnElmtId(rmElmtId);
        this.__showAnalysis.purgeDependencyOnElmtId(rmElmtId);
        this.__historyRecords.purgeDependencyOnElmtId(rmElmtId);
        this.__globalDarkMode.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__currentTime.aboutToBeDeleted();
        this.__modeEnabled.aboutToBeDeleted();
        this.__studySeconds.aboutToBeDeleted();
        this.__isStudying.aboutToBeDeleted();
        this.__todayTotalSeconds.aboutToBeDeleted();
        this.__showAnalysis.aboutToBeDeleted();
        this.__historyRecords.aboutToBeDeleted();
        this.__globalDarkMode.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    // 状态变量
    private __currentTime: ObservedPropertySimplePU<string>;
    get currentTime() {
        return this.__currentTime.get();
    }
    set currentTime(newValue: string) {
        this.__currentTime.set(newValue);
    }
    private __modeEnabled: ObservedPropertySimplePU<boolean>;
    get modeEnabled() {
        return this.__modeEnabled.get();
    }
    set modeEnabled(newValue: boolean) {
        this.__modeEnabled.set(newValue);
    }
    private __studySeconds: ObservedPropertySimplePU<number>;
    get studySeconds() {
        return this.__studySeconds.get();
    }
    set studySeconds(newValue: number) {
        this.__studySeconds.set(newValue);
    }
    private __isStudying: ObservedPropertySimplePU<boolean>;
    get isStudying() {
        return this.__isStudying.get();
    }
    set isStudying(newValue: boolean) {
        this.__isStudying.set(newValue);
    }
    private __todayTotalSeconds: ObservedPropertySimplePU<number>;
    get todayTotalSeconds() {
        return this.__todayTotalSeconds.get();
    }
    set todayTotalSeconds(newValue: number) {
        this.__todayTotalSeconds.set(newValue);
    }
    private __showAnalysis: ObservedPropertySimplePU<boolean>;
    get showAnalysis() {
        return this.__showAnalysis.get();
    }
    set showAnalysis(newValue: boolean) {
        this.__showAnalysis.set(newValue);
    }
    private __historyRecords: ObservedPropertyObjectPU<HistoryRecord[]>;
    get historyRecords() {
        return this.__historyRecords.get();
    }
    set historyRecords(newValue: HistoryRecord[]) {
        this.__historyRecords.set(newValue);
    }
    // 私有变量
    private studyTimerId: number;
    private timeUpdateTimerId: number;
    private preference: preferences.Preferences | null;
    private hasInitialized: boolean;
    private __globalDarkMode: ObservedPropertySimplePU<boolean>; // 改为 @State，确保响应式更新
    get globalDarkMode() {
        return this.__globalDarkMode.get();
    }
    set globalDarkMode(newValue: boolean) {
        this.__globalDarkMode.set(newValue);
    }
    private listenerId: string; // 主题监听器 ID
    // 颜色主题方法（统一 Mypage 风格：基于 globalDarkMode 硬编码返回）
    getBackgroundColor(): string {
        return this.globalDarkMode ? '#000000' : '#FFFFFF';
    }
    getTextColor(): string {
        return this.globalDarkMode ? '#FFFFFF' : '#000000';
    }
    getCardColor(): string {
        return this.globalDarkMode ? '#1C1C1E' : '#F0F8FF';
    }
    getSecondaryTextColor(): string {
        return this.globalDarkMode ? '#8E8E93' : '#666666';
    }
    getAccentColor(): string {
        return this.globalDarkMode ? '#0A84FF' : '#007AFF';
    }
    getSurfaceColor(): string {
        return this.globalDarkMode ? '#2C2C2E' : '#E3F2FD';
    }
    getSuccessColor(): string {
        return this.globalDarkMode ? '#30D158' : '#34C759';
    }
    getWarningColor(): string {
        return this.globalDarkMode ? '#FF9F0A' : '#FF9500';
    }
    getDangerColor(): string {
        return this.globalDarkMode ? '#FF453A' : '#FF3B30';
    }
    getProgressBackgroundColor(): string {
        return this.globalDarkMode ? '#3A3A3C' : '#E5E5EA';
    }
    // 生命周期 - 页面显示时（统一 Mypage 风格：同步初始化 + 异步验证 + 监听器）
    async aboutToAppear(): Promise<void> {
        console.log('=== 页面显示 ===');
        if (this.hasInitialized) {
            console.log('页面已初始化，跳过重复初始化');
            return;
        }
        this.updateTime();
        await this.initPreferences(); // 添加 await
        await this.loadStudyHistory(); // 添加 await
        // 统一 Mypage 风格：同步立即设置 UI 状态 + 异步验证一致性
        this.globalDarkMode = ThemeManager.getCurrentThemeSync(); // 立即同步 UI
        try {
            const actualTheme = await ThemeManager.getIsDarkMode(); // 异步验证
            if (this.globalDarkMode !== actualTheme) {
                this.globalDarkMode = actualTheme;
            }
            console.info(`SelfDiscipline 初始化完成: ${this.globalDarkMode ? '深色' : '浅色'}`);
        }
        catch (error) {
            console.error('SelfDiscipline 主题初始化失败:', error);
            this.globalDarkMode = false; // 回退到浅色
        }
        // 统一 Mypage 风格：简化监听器逻辑
        const themeCallback = (isDark: boolean) => {
            if (this.globalDarkMode !== isDark) {
                console.info(`监听器触发主题变更: ${isDark ? '深色' : '浅色'}`);
                this.globalDarkMode = isDark; // 更新 @State，触发 UI 重绘
            }
        };
        if (!ThemeManager.hasListener(themeCallback)) {
            this.listenerId = ThemeManager.addListener(themeCallback);
            console.log('SelfDiscipline 主题监听器已添加');
        }
        this.timeUpdateTimerId = setInterval(() => {
            this.updateTime();
        }, 60000);
        this.hasInitialized = true;
    }
    // 生命周期 - 页面消失时（统一 Mypage 风格：移除监听器）
    aboutToDisappear(): void {
        console.log('=== 页面消失 ===');
        this.cleanupAllTimers();
        // 统一 Mypage 风格：移除监听器
        if (this.listenerId) {
            ThemeManager.removeListener(this.listenerId);
            this.listenerId = '';
            console.log('SelfDiscipline 主题监听器已移除');
        }
        if (this.isStudying || this.studySeconds > 0) {
            this.saveStudyData();
        }
    }
    // 清理所有计时器
    private cleanupAllTimers(): void {
        console.log('清理所有计时器');
        if (this.timeUpdateTimerId) {
            clearInterval(this.timeUpdateTimerId);
            this.timeUpdateTimerId = 0;
        }
        if (this.studyTimerId) {
            clearInterval(this.studyTimerId);
            this.studyTimerId = 0;
        }
    }
    // 初始化Preferences
    async initPreferences(): Promise<void> {
        try {
            const context = getContext(this);
            this.preference = await preferences.getPreferences(context, 'study_records');
            console.log('Preferences初始化成功');
        }
        catch (error) {
            console.error('Preferences初始化失败:', error);
        }
    }
    // 加载历史记录（保持原样）
    async loadStudyHistory(): Promise<void> {
        if (!this.preference) {
            console.log('Preferences未初始化，延迟加载');
            setTimeout(() => {
                this.loadStudyHistory();
            }, 100);
            return;
        }
        try {
            const today = new Date().toISOString().split('T')[0];
            console.log('加载今日数据，日期:', today);
            // 加载今日学习时间
            const savedTodaySeconds = await this.preference.get('today_' + today, 0);
            this.todayTotalSeconds = Number(savedTodaySeconds);
            console.log('今日总学习时间:', this.todayTotalSeconds);
            // 正确处理ValueType类型
            const historyData = await this.preference.get('history_records', '[]');
            // 安全地处理ValueType类型
            let historyDataStr: string = '[]';
            if (typeof historyData === 'string') {
                historyDataStr = historyData;
                console.log('历史数据是字符串类型，长度:', historyDataStr.length);
            }
            else if (typeof historyData === 'number' || typeof historyData === 'boolean') {
                // 如果存储的是数字或布尔值，转换为字符串
                historyDataStr = String(historyData);
                console.log('历史数据是数字/布尔类型，转换为字符串，长度:', historyDataStr.length);
            }
            else {
                // 其他类型使用默认值
                historyDataStr = '[]';
                console.log('历史数据是未知类型，使用默认值');
            }
            let parsedRecords: HistoryRecord[] = [];
            if (historyDataStr.trim() !== '' && historyDataStr !== '[]') {
                try {
                    parsedRecords = JSON.parse(historyDataStr) as HistoryRecord[];
                    console.log('成功解析历史记录，记录数:', parsedRecords.length);
                }
                catch (parseError) {
                    console.error('JSON解析失败，使用空数组');
                    parsedRecords = [];
                }
            }
            else {
                console.log('历史数据为空，使用空数组');
                parsedRecords = [];
            }
            // 确保是数组且过滤有效记录
            if (!Array.isArray(parsedRecords)) {
                console.error('解析结果不是数组，重置为空数组');
                parsedRecords = [];
            }
            this.historyRecords = parsedRecords.filter((record: HistoryRecord) => {
                const isValid = record &&
                    typeof record.date === 'string' &&
                    typeof record.seconds === 'number' &&
                    typeof record.formattedTime === 'string';
                if (!isValid) {
                    console.warn('过滤掉无效记录:', record);
                }
                return isValid;
            });
            // 按日期倒序排列
            this.historyRecords.sort((a: HistoryRecord, b: HistoryRecord): number => b.date.localeCompare(a.date));
            console.log('历史记录加载完成，有效记录数:', this.historyRecords.length);
        }
        catch (error) {
            console.error('加载学习历史失败:', error);
        }
    }
    // 保存数据（保持原样）
    async saveStudyData(): Promise<void> {
        if (!this.preference) {
            console.log('Preferences未初始化，跳过保存');
            return;
        }
        try {
            const today = new Date().toISOString().split('T')[0];
            console.log('保存数据，日期:', today, '总时间:', this.todayTotalSeconds);
            // 保存今日数据
            await this.preference.put('today_' + today, this.todayTotalSeconds);
            // 更新或添加今日记录到历史记录
            const existingIndex = this.historyRecords.findIndex((record: HistoryRecord): boolean => record.date === today);
            if (existingIndex >= 0) {
                // 更新现有记录
                this.historyRecords[existingIndex].seconds = this.todayTotalSeconds;
                this.historyRecords[existingIndex].formattedTime = this.formatStudyTime(this.todayTotalSeconds);
                console.log('更新现有记录，索引:', existingIndex);
            }
            else if (this.todayTotalSeconds > 0) {
                // 只在有学习时间时添加新记录
                const newRecord: HistoryRecord = {
                    date: today,
                    seconds: this.todayTotalSeconds,
                    formattedTime: this.formatStudyTime(this.todayTotalSeconds)
                };
                this.historyRecords.unshift(newRecord);
                console.log('添加新记录');
            }
            // 只保留最近7天记录
            if (this.historyRecords.length > 7) {
                this.historyRecords = this.historyRecords.slice(0, 7);
                console.log('截断记录为最近7天');
            }
            // 保存历史记录
            const historyJson = JSON.stringify(this.historyRecords);
            await this.preference.put('history_records', historyJson);
            await this.preference.flush();
            console.log('数据保存成功，历史记录数:', this.historyRecords.length);
        }
        catch (error) {
            console.error('保存学习数据失败:', error);
        }
    }
    // 更新时间显示
    updateTime(): void {
        const now: Date = new Date();
        const hours: string = now.getHours().toString().padStart(2, '0');
        const minutes: string = now.getMinutes().toString().padStart(2, '0');
        this.currentTime = `${hours}:${minutes}`;
    }
    // 开启自律模式
    enableMode(): void {
        console.log('=== 开启自律模式 ===');
        this.cleanupAllTimers();
        this.studySeconds = 0;
        this.isStudying = false;
        this.showAnalysis = false;
        this.modeEnabled = true;
        this.startStudyTimer();
        console.log('自律模式开启完成');
    }
    // 开始学习计时
    startStudyTimer(): void {
        if (this.studyTimerId !== 0) {
            this.pauseStudyTimer();
        }
        console.log('启动学习计时器');
        this.isStudying = true;
        this.studyTimerId = setInterval((): void => {
            if (this.modeEnabled && this.isStudying) {
                this.studySeconds++;
                this.todayTotalSeconds++;
                // 每30秒自动保存一次数据
                if (this.studySeconds % 30 === 0) {
                    this.saveStudyData();
                }
            }
        }, 1000);
    }
    // 暂停学习计时
    pauseStudyTimer(): void {
        if (this.studyTimerId !== 0) {
            clearInterval(this.studyTimerId);
            this.studyTimerId = 0;
        }
        this.isStudying = false;
        this.saveStudyData();
    }
    // 继续学习计时
    resumeStudyTimer(): void {
        if (this.studyTimerId === 0) {
            this.startStudyTimer();
        }
    }
    // 停止学习计时
    stopStudyTimer(): void {
        console.log('=== 停止学习计时器 ===');
        this.pauseStudyTimer();
        this.saveStudyData().then(() => {
            this.studySeconds = 0;
            this.showAnalysis = false;
            this.modeEnabled = false;
            console.log('停止学习完成，返回初始界面');
        });
    }
    // 切换分析视图
    toggleAnalysis(): void {
        this.showAnalysis = !this.showAnalysis;
    }
    // 格式化学习时间
    formatStudyTime(seconds: number): string {
        const hours: number = Math.floor(seconds / 3600);
        const minutes: number = Math.floor((seconds % 3600) / 60);
        const secs: number = seconds % 60;
        return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
    }
    // 获取学习进度描述
    getStudyProgressText(): string {
        if (this.studySeconds < 60) {
            return '刚刚开始，加油！';
        }
        else if (this.studySeconds < 1800) {
            return '已经坚持了一段时间，继续保持！';
        }
        else if (this.studySeconds < 3600) {
            return '学习半小时了，很棒！';
        }
        else {
            const hours: number = Math.floor(this.studySeconds / 3600);
            return `已经学习${hours}小时，非常专注！`;
        }
    }
    // 获取日期显示格式
    getDisplayDate(dateStr: string): string {
        const today = new Date().toISOString().split('T')[0];
        const yesterday = new Date(Date.now() - 86400000).toISOString().split('T')[0];
        if (dateStr === today) {
            return '今天';
        }
        else if (dateStr === yesterday) {
            return '昨天';
        }
        else {
            const parts = dateStr.split('-');
            if (parts.length === 3) {
                return `${parseInt(parts[1], 10)}月${parseInt(parts[2], 10)}日`;
            }
            return dateStr;
        }
    }
    getTodayAnalysis(): string {
        if (this.todayTotalSeconds === 0) {
            return '今日尚未开始学习';
        }
        const totalMinutes: number = Math.floor(this.todayTotalSeconds / 60);
        if (totalMinutes < 30) {
            return '学习时间较短，建议延长专注时间';
        }
        else if (totalMinutes < 60) {
            return '学习时间适中，保持良好节奏';
        }
        else if (totalMinutes < 120) {
            return '学习时间充足，效率很高';
        }
        else if (totalMinutes < 240) {
            return '学习时间很长，注意适当休息';
        }
        else {
            return '学习时间非常长，注意劳逸结合';
        }
    }
    getEfficiencyAnalysis(): string {
        if (this.todayTotalSeconds === 0) {
            return '今日尚未开始学习';
        }
        const totalMinutes: number = Math.floor(this.todayTotalSeconds / 60);
        if (totalMinutes < 30) {
            return '学习时间较短，建议延长单次学习时间';
        }
        else if (totalMinutes < 60) {
            return '学习时间适中，保持良好节奏';
        }
        else if (totalMinutes < 120) {
            return '学习时间较长，注意适当休息';
        }
        else {
            return '学习时间很长，注意劳逸结合';
        }
    }
    getEfficiencyScore(): string {
        if (this.todayTotalSeconds === 0) {
            return '暂无数据';
        }
        const totalMinutes: number = Math.floor(this.todayTotalSeconds / 60);
        if (totalMinutes < 30) {
            return '⭐☆☆☆☆ 需要加强';
        }
        else if (totalMinutes < 60) {
            return '⭐⭐☆☆☆ 良好';
        }
        else if (totalMinutes < 120) {
            return '⭐⭐⭐☆☆ 优秀';
        }
        else if (totalMinutes < 180) {
            return '⭐⭐⭐⭐☆ 非常优秀';
        }
        else {
            return '⭐⭐⭐⭐⭐ 极致专注';
        }
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.height('100%');
            Column.padding(20);
            Column.backgroundColor(this.getBackgroundColor());
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 标题区域
            Text.create('自律模式');
            // 标题区域
            Text.fontSize(24);
            // 标题区域
            Text.fontWeight(FontWeight.Bold);
            // 标题区域
            Text.margin({ bottom: 10 });
            // 标题区域
            Text.fontColor(this.getTextColor());
        }, Text);
        // 标题区域
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 当前时间
            Text.create(`当前时间: ${this.currentTime}`);
            // 当前时间
            Text.fontSize(16);
            // 当前时间
            Text.width('100%');
            // 当前时间
            Text.textAlign(TextAlign.Start);
            // 当前时间
            Text.fontColor(this.getTextColor());
        }, Text);
        // 当前时间
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 描述文本
            Text.create('专注学习，提升效率');
            // 描述文本
            Text.fontSize(14);
            // 描述文本
            Text.fontColor(this.getSecondaryTextColor());
            // 描述文本
            Text.width('100%');
            // 描述文本
            Text.textAlign(TextAlign.Start);
            // 描述文本
            Text.margin({ bottom: 20 });
        }, Text);
        // 描述文本
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            // 主要内容区域
            if (!this.modeEnabled) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.buildStartView.bind(this)();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.buildStudyView.bind(this)();
                });
            }
        }, If);
        If.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 底部空白
            Blank.create();
            // 底部空白
            Blank.layoutWeight(1);
        }, Blank);
        // 底部空白
        Blank.pop();
        // 底部按钮
        this.buildBottomButtons.bind(this)();
        Column.pop();
    }
    buildStartView(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 开启按钮区域
            Column.create({ space: 15 });
            // 开启按钮区域
            Column.width('100%');
            // 开启按钮区域
            Column.padding(20);
            // 开启按钮区域
            Column.backgroundColor(this.getCardColor());
            // 开启按钮区域
            Column.borderRadius(16);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('准备好开始专注学习了吗？');
            Text.fontSize(16);
            Text.fontColor(this.getTextColor());
            Text.textAlign(TextAlign.Center);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('开启自律模式');
            Button.type(ButtonType.Capsule);
            Button.width('90%');
            Button.height(55);
            Button.backgroundColor(this.getAccentColor());
            Button.fontColor('#FFFFFF');
            Button.fontSize(18);
            Button.onClick((): void => {
                this.enableMode();
            });
        }, Button);
        Button.pop();
        // 开启按钮区域
        Column.pop();
        // 学习记录显示
        this.buildStudyRecords.bind(this)();
        Column.pop();
    }
    buildStudyRecords(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 15 });
            Column.width('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 标题
            Row.create();
            // 标题
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('学习记录');
            Text.fontSize(18);
            Text.fontColor(this.getTextColor());
            Text.fontWeight(FontWeight.Bold);
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('最近7天');
            Text.fontSize(12);
            Text.fontColor(this.getSecondaryTextColor());
        }, Text);
        Text.pop();
        // 标题
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            // 今日学习统计
            if (this.todayTotalSeconds > 0) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Column.create({ space: 10 });
                        Column.width('100%');
                        Column.padding(15);
                        Column.backgroundColor(this.getSurfaceColor());
                        Column.borderRadius(12);
                    }, Column);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Row.create();
                        Row.width('100%');
                    }, Row);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('今日学习时间');
                        Text.fontSize(16);
                        Text.fontColor(this.getTextColor());
                        Text.fontWeight(FontWeight.Medium);
                        Text.layoutWeight(1);
                    }, Text);
                    Text.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create(this.formatStudyTime(this.todayTotalSeconds));
                        Text.fontSize(16);
                        Text.fontColor(this.getAccentColor());
                        Text.fontWeight(FontWeight.Bold);
                    }, Text);
                    Text.pop();
                    Row.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create(this.getTodayAnalysis());
                        Text.fontSize(12);
                        Text.fontColor(this.getSecondaryTextColor());
                        Text.width('100%');
                        Text.textAlign(TextAlign.Start);
                    }, Text);
                    Text.pop();
                    Column.pop();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Column.create({ space: 10 });
                        Column.width('100%');
                        Column.padding(15);
                        Column.backgroundColor(this.getSurfaceColor());
                        Column.borderRadius(12);
                    }, Column);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('今日尚未开始学习');
                        Text.fontSize(14);
                        Text.fontColor(this.getSecondaryTextColor());
                    }, Text);
                    Text.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('开启自律模式开始记录学习时间');
                        Text.fontSize(12);
                        Text.fontColor(this.getSecondaryTextColor());
                    }, Text);
                    Text.pop();
                    Column.pop();
                });
            }
        }, If);
        If.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            // 历史记录列表
            if (this.historyRecords.length > 0) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Column.create({ space: 10 });
                        Column.width('100%');
                    }, Column);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('历史记录');
                        Text.fontSize(16);
                        Text.fontColor(this.getTextColor());
                        Text.fontWeight(FontWeight.Medium);
                        Text.width('100%');
                        Text.textAlign(TextAlign.Start);
                    }, Text);
                    Text.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        ForEach.create();
                        const forEachItemGenFunction = _item => {
                            const item = _item;
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Column.create({ space: 8 });
                                Column.width('100%');
                                Column.padding(10);
                                Column.backgroundColor(this.getCardColor());
                                Column.borderRadius(8);
                            }, Column);
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Row.create();
                                Row.width('100%');
                            }, Row);
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Text.create(this.getDisplayDate(item.date));
                                Text.fontSize(14);
                                Text.fontColor(this.getTextColor());
                                Text.layoutWeight(1);
                            }, Text);
                            Text.pop();
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Text.create(item.formattedTime);
                                Text.fontSize(14);
                                Text.fontColor(this.getAccentColor());
                                Text.fontWeight(FontWeight.Medium);
                            }, Text);
                            Text.pop();
                            Row.pop();
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                // 进度条
                                Stack.create();
                                // 进度条
                                Stack.width('100%');
                                // 进度条
                                Stack.height(4);
                            }, Stack);
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Row.create();
                                Row.width('100%');
                                Row.height(4);
                                Row.backgroundColor(this.getProgressBackgroundColor());
                            }, Row);
                            Row.pop();
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Row.create();
                                Row.width(`${Math.min(100, (item.seconds / 28800) * 100)}%`);
                                Row.height(4);
                                Row.backgroundColor(item.seconds >= 7200 ? this.getSuccessColor() :
                                    item.seconds >= 3600 ? this.getWarningColor() : this.getDangerColor());
                            }, Row);
                            Row.pop();
                            // 进度条
                            Stack.pop();
                            Column.pop();
                        };
                        this.forEachUpdateFunction(elmtId, this.historyRecords, forEachItemGenFunction);
                    }, ForEach);
                    ForEach.pop();
                    Column.pop();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Column.create({ space: 10 });
                        Column.width('100%');
                        Column.padding(20);
                        Column.backgroundColor(this.getCardColor());
                        Column.borderRadius(12);
                    }, Column);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('暂无历史记录');
                        Text.fontSize(14);
                        Text.fontColor(this.getSecondaryTextColor());
                    }, Text);
                    Text.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('开始使用自律模式后将会记录您的学习数据');
                        Text.fontSize(12);
                        Text.fontColor(this.getSecondaryTextColor());
                    }, Text);
                    Text.pop();
                    Column.pop();
                });
            }
        }, If);
        If.pop();
        Column.pop();
    }
    buildStudyView(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.padding(20);
            Column.backgroundColor(this.getCardColor());
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 标题和控制区域
            Row.create();
            // 标题和控制区域
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('自律模式已开启');
            Text.fontSize(20);
            Text.fontColor(this.getAccentColor());
            Text.fontWeight(FontWeight.Bold);
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.showAnalysis ? '隐藏分析' : '查看分析');
            Button.type(ButtonType.Normal);
            Button.height(32);
            Button.backgroundColor(this.getCardColor());
            Button.fontColor(this.getAccentColor());
            Button.fontSize(12);
            Button.onClick((): void => {
                this.toggleAnalysis();
            });
        }, Button);
        Button.pop();
        // 标题和控制区域
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            // 内容区域
            if (!this.showAnalysis) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.buildBasicInfoView.bind(this)();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.buildAnalysisView.bind(this)();
                });
            }
        }, If);
        If.pop();
        // 控制面板
        this.buildControlPanel.bind(this)();
        Column.pop();
    }
    buildBasicInfoView(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 15 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 实时计时显示
            Column.create({ space: 10 });
            // 实时计时显示
            Column.width('100%');
            // 实时计时显示
            Column.padding(20);
            // 实时计时显示
            Column.backgroundColor(this.getSurfaceColor());
            // 实时计时显示
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('本次学习时间');
            Text.fontSize(16);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.formatStudyTime(this.studySeconds));
            Text.fontSize(32);
            Text.fontWeight(FontWeight.Bold);
            Text.fontColor(this.getAccentColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.getStudyProgressText());
            Text.fontSize(14);
            Text.fontColor(this.getSecondaryTextColor());
        }, Text);
        Text.pop();
        // 实时计时显示
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 今日统计
            Column.create({ space: 10 });
            // 今日统计
            Column.width('100%');
            // 今日统计
            Column.padding(15);
            // 今日统计
            Column.backgroundColor(this.getCardColor());
            // 今日统计
            Column.borderRadius(8);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('今日学习统计');
            Text.fontSize(16);
            Text.fontColor(this.getTextColor());
            Text.fontWeight(FontWeight.Medium);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('总学习时间:');
            Text.fontSize(14);
            Text.fontColor(this.getTextColor());
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.formatStudyTime(this.todayTotalSeconds));
            Text.fontSize(14);
            Text.fontColor(this.getAccentColor());
            Text.fontWeight(FontWeight.Medium);
        }, Text);
        Text.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('本次会话:');
            Text.fontSize(14);
            Text.fontColor(this.getTextColor());
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.formatStudyTime(this.studySeconds));
            Text.fontSize(14);
            Text.fontColor(this.getAccentColor());
        }, Text);
        Text.pop();
        Row.pop();
        // 今日统计
        Column.pop();
        Column.pop();
    }
    buildAnalysisView(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 15 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 10 });
            Column.width('100%');
            Column.padding(15);
            Column.backgroundColor(this.getSurfaceColor());
            Column.borderRadius(8);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('学习效率分析');
            Text.fontSize(16);
            Text.fontColor(this.getTextColor());
            Text.fontWeight(FontWeight.Medium);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.getEfficiencyAnalysis());
            Text.fontSize(14);
            Text.fontColor(this.getSecondaryTextColor());
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 8 });
            Column.width('100%');
            Column.padding(15);
            Column.backgroundColor(this.getCardColor());
            Column.borderRadius(8);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('详细统计');
            Text.fontSize(16);
            Text.fontColor(this.getTextColor());
            Text.fontWeight(FontWeight.Medium);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('今日总时长:');
            Text.fontSize(14);
            Text.fontColor(this.getTextColor());
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.formatStudyTime(this.todayTotalSeconds));
            Text.fontSize(14);
            Text.fontColor(this.getAccentColor());
            Text.fontWeight(FontWeight.Medium);
        }, Text);
        Text.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('本次时长:');
            Text.fontSize(14);
            Text.fontColor(this.getTextColor());
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.formatStudyTime(this.studySeconds));
            Text.fontSize(14);
            Text.fontColor(this.getAccentColor());
        }, Text);
        Text.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('学习效率:');
            Text.fontSize(14);
            Text.fontColor(this.getTextColor());
            Text.layoutWeight(1);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.getEfficiencyScore());
            Text.fontSize(14);
            Text.fontColor(this.getSuccessColor());
        }, Text);
        Text.pop();
        Row.pop();
        Column.pop();
        Column.pop();
    }
    buildControlPanel(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 15 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create({ space: 15 });
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.isStudying ? '暂停学习' : '继续学习');
            Button.type(ButtonType.Normal);
            Button.layoutWeight(1);
            Button.height(40);
            Button.backgroundColor(this.isStudying ? this.getDangerColor() : this.getSuccessColor());
            Button.fontColor('#FFFFFF');
            Button.fontSize(14);
            Button.onClick((): void => {
                if (this.isStudying) {
                    this.pauseStudyTimer();
                }
                else {
                    this.resumeStudyTimer();
                }
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('停止学习');
            Button.type(ButtonType.Normal);
            Button.layoutWeight(1);
            Button.height(40);
            Button.backgroundColor(this.getCardColor());
            Button.fontColor(this.getTextColor());
            Button.fontSize(14);
            Button.onClick((): void => {
                this.stopStudyTimer();
            });
        }, Button);
        Button.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('提示：停止学习将结束本次会话');
            Text.fontSize(12);
            Text.fontColor(this.getSecondaryTextColor());
            Text.width('100%');
            Text.textAlign(TextAlign.Center);
        }, Text);
        Text.pop();
        Column.pop();
    }
    buildBottomButtons(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 10 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('返回主页');
            Button.type(ButtonType.Normal);
            Button.width('90%');
            Button.height(45);
            Button.backgroundColor(this.getCardColor());
            Button.fontColor(this.getTextColor());
            Button.onClick((): void => {
                this.cleanupAllTimers();
                router.back();
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "SelfDiscipline";
    }
}
registerNamedRoute(() => new SelfDiscipline(undefined, {}), "", { bundleName: "com.example.myapplication", moduleName: "entry", pagePath: "pages/SelfDiscipline", pageFullPath: "entry/src/main/ets/pages/SelfDiscipline", integratedHsp: "false" });
